<?php

namespace App\Http\Controllers\DiscoveryTools\Zoom;

use App\Http\Controllers\Controller;
use App\Http\Traits\Common\DataTableControllerTrait;
use App\Services\DiscoveryTools\Zoom\DevicesOnHand;

class DevicesOnHandController extends Controller
{
    use DataTableControllerTrait;

    /**
     * Constructor for the DevicesOnHandController.
     *
     * @param DevicesOnHand $service The service class instance for handling 'Devices On Hand' operations.
     */
    public function __construct(protected DevicesOnHand $service) {}

    /**
     * Display the 'Devices On Hand' report view.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('discovery-tools.zoom.devices-on-hand-checking-in');
    }
}
