<?php

namespace App\Http\Controllers\DiscoveryTools\Zoom;

use App\Http\Controllers\Controller;
use App\Http\Traits\Common\DataTableControllerTrait;
use App\Services\DiscoveryTools\Zoom\DevicesNotCreated;

class DevicesNotCreatedController extends Controller
{
    use DataTableControllerTrait;

    /**
     * Constructor for the DevicesNotCreatedController.
     *
     * @param DevicesNotCreated $service The service class instance for handling 'Devices Not Created' operations.
     */
    public function __construct(protected DevicesNotCreated $service) {}

    /**
     * Showing the Devices Not Created report for Zoom
     *
     * @return view
     */
    public function index()
    {
        return view('discovery-tools.zoom.devices-not-created');
    }
}
