<?php

namespace App\Http\Controllers\DiscoveryTools\Zoom;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Http\Traits\Common\DataTableControllerTrait;
use App\Services\DiscoveryTools\Zoom\DevicesNotActive;

class DevicesNotActiveController extends Controller
{
    use DataTableControllerTrait;

    /**
     * Constructor for the DevicesNotActiveController.
     *
     * @param DevicesNotActive $service The service class instance for handling 'Devices Not Active' operations.
     */
    public function __construct(protected DevicesNotActive $service) {}

    /**
     * Display the 'Zoom - Devices Not Active' report view.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('discovery-tools.zoom.devices-not-active');
    }
}
