<?php

namespace App\Http\Controllers\DiscoveryTools\Zoom;

use App\Http\Controllers\Controller;
use App\Http\Traits\Common\DataTableControllerTrait;
use App\Services\DiscoveryTools\Zoom\LocationDiscrepancy;

class DevicesLocationDiscrepancyController extends Controller
{
    use DataTableControllerTrait;

    /**
     * Constructs a new instance of the DevicesLocationDiscrepancyController class.
     *
     * @param LocationDiscrepancy $service The LocationDiscrepancy service instance
     */
    public function __construct(protected LocationDiscrepancy $service) {}

    /**
     * Showing the `Location Discrepancy` report
     *
     * @return view
     */
    public function index()
    {
        return view('discovery-tools.zoom.location-discrepancy');
    }
}
