<?php

namespace App\Http\Controllers\DiscoveryTools\Zoom;

use App\Http\Controllers\Controller;
use App\Http\Traits\Common\DataTableControllerTrait;
use App\Services\DiscoveryTools\Zoom\AllZoomService;

class AllReportController extends Controller
{
    use DataTableControllerTrait;

    /**
     * Constructor for the class.
     *
     * @param AllZoomService $service The AllZoomService instance used for report generation.
     */
    public function __construct(protected AllZoomService $service) {}

    /**
     * Showing the 'All Zoom' Report
     *
     * @return view
     */
    public function index()
    {
        return view('discovery-tools.zoom.all-report');
    }
}
