<?php

namespace App\Http\Controllers\DiscoveryTools\WorkspaceOne;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\DiscoveryTools\WorkspaceOne\CheckingInUserDiscrepancy;
use App\Http\Responses\ReportJsonResponse;
use App\Models\IntegrationSyncHistory;
use Cache;

class CheckingInUserDiscrepancyController extends Controller
{
    protected $workspaceOneService;

    public function __construct(CheckingInUserDiscrepancy $workspaceOneService)
    {
        $this->workspaceOneService = $workspaceOneService;
    }

    /**
     * User Descrepancy page
     * @return [type]
     */
    public function index()
    {
        $lastSync = IntegrationSyncHistory::getLastSync(config('integration-sync-histories.chromebook'))->first();
        $lastSyncDate = $lastSync?->created_at;

        return view('discovery-tools.workspace-one.checking-in-user-discrepancy', compact('lastSyncDate'));
    }

    /**
     * Data for showing in the table
     * @param Request $request
     *
     * @return [type]
     */
    public function data(Request $request)
    {
        $filteredData = $this->workspaceOneService->data();

        if (!empty($filteredData['assets'])) {
            $data = $this->workspaceOneService->getReportData($filteredData['assets'], request('start'));
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }

    /**
     * export the report to csv
     *
     * @return [type]
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        $assetsNotCreated = $this->workspaceOneService->exportData();
        $requiredColumns = config('discovery-tools-export-columns.workspaceOne.Common');

        $assetsNotCreated->chunk(5000, function ($assetChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->workspaceOneService->getReportExportData($assetChunks, 0, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
