<?php

namespace App\Http\Controllers\DiscoveryTools\MobileIron;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Models\IntegrationSyncHistory;
use App\Services\DiscoveryTools\MobileIron\MobileNumber;
use Illuminate\Http\Request;

class MobileNumberController extends Controller
{
    protected $mobileIronService;

    public function __construct(MobileNumber $mobileIronService)
    {
        $this->mobileIronService = $mobileIronService;
    }

    /**
     * Showing the Mobile Number Report
     * @return Http\Response
     */
    public function index()
    {
        $lastSync = IntegrationSyncHistory::getLastSync(config('integration-sync-histories.mobile-iron'))->first();
        $lastSyncDate = $lastSync?->created_at;

        return view('discovery-tools.mobile-iron.mobile-number', compact('lastSyncDate'));
    }

    /**
     * Taking the data to the `Mobile Number` report
     *
     * @param Illuminate\Http\Request $request
     * @return Http\Response
     */
    public function data(Request $request)
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $filteredData = $this->mobileIronService->data();
        $assets = $filteredData['assets'];


        $start = request('start');
        $data = [];

        if (!empty($assets)) {
            $data = $this->mobileIronService->getReportData($assets, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }


    /**
     * Taking the data to the `Mobile Number` report
     *
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        $filteredData = $this->mobileIronService->exportData();
        $requiredColumns = config('discovery-tools-export-columns.MobileIron.Common');
        $filteredData->chunk(5000, function ($filteredDataChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->mobileIronService->getReportExportData($filteredDataChunks, 0, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
