<?php

namespace App\Http\Controllers\DiscoveryTools\MobileIron;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\DiscoveryTools\MobileIron\MobileIronService;

class IndexController extends Controller
{
    protected $mobileIronService;

    public function __construct(MobileIronService $mobileIronService)
    {
        $this->service = $mobileIronService;
    }

    /**
     * Populate filter dropdowns based on search
     * @param Request $request
     * 
     * @return [type]
     */
    public function getFilterFields(Request $request)
    {
        if (!empty($request->search)) {

            $result = $this->service->getFilterMobileIronFields($request->search, $request->type);

            if (!$result->count()) {
                $result[] = ['id' => '0', 'label' => 'No result found', 'data' => ''];
            }

            return response()->json($result);
        }
    }
}
