<?php

namespace App\Http\Controllers\DiscoveryTools\Kandji;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Models\IntegrationSyncHistory;
use App\Services\DiscoveryTools\Kandji\NotCheckingInNotManaged;
use Illuminate\Http\Request;

class NotCheckingInNotManagedController extends Controller
{


    public function __construct(NotCheckingInNotManaged $service)
    {
        $this->service = $service;
    }

    /**
     * Showing the Mobile Number Report
     * @return Http\Response
     */
    public function index()
    {
        $lastSync = IntegrationSyncHistory::getLastSync(config('integration-sync-histories.kandji'))->first();
        $lastSyncDate = $lastSync?->created_at;

        return view('discovery-tools.kandji.not-checking-in-not-managed', compact('lastSyncDate'));
    }

    /**
     * Taking the data to the `Mobile Number` report
     *
     * @param Illuminate\Http\Request $request
     * @return Http\Response
     */
    public function data(Request $request)
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $filteredData = $this->service->data();
        $assets = $filteredData['assets'];


        $start = request('start');
        $data = [];

        if (!empty($assets)) {
            $data = $this->service->getReportData($assets, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }


    /**
     * Taking the data to the `Mobile Number` report
     *
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        $filteredData = $this->service->exportData();
        $requiredColumns = config('discovery-tools-export-columns.Kandji.DeviceActiveButNotManaged');
        $filteredData->chunk(5000, function ($filteredDataChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->service->getReportExportData($filteredDataChunks, 0, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
