<?php

namespace App\Http\Controllers\DiscoveryTools\Kandji;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\DiscoveryTools\Kandji\KandjiService;

class IndexController extends Controller
{
    protected $serviceClass;

    public function __construct(KandjiService $serviceClass)
    {
        $this->serviceClass = $serviceClass;
    }

    public function getFilterFields(Request $request)
    {
        if(!empty($request->search)) {
            
            $result = $this->serviceClass->getFilterFields($request->search, $request->type);
                       
            if (!$result->count()) {
                $result[] = ['id' => '0', 'label' => 'No result found', 'data' => ''];
            }

            return response()->json($result);
        }
    }
}
