<?php

namespace App\Http\Controllers\DiscoveryTools\Kandji;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Models\IntegrationSyncHistory;
use Illuminate\Http\Request;
use App\Services\DiscoveryTools\Kandji\CheckingInOnHand;
use Illuminate\Support\Facades\Cache;

/**
 * Controller calss for Devices On Hand Checking In report
 */
class CheckingInOnHandController extends Controller
{
    public function __construct(CheckingInOnHand $service)
    {
        $this->service = $service;
    }

    /**
     * Showing the Devices that are not in teqtivity but in Kandji
     * @return Http\Response
     */
    public function index()
    {
        $lastSync = IntegrationSyncHistory::getLastSync(config('integration-sync-histories.kandji'))->first();
        $lastSyncDate = $lastSync?->created_at;

        return view('discovery-tools.kandji.checking-in-on-hand', compact('lastSyncDate'));
    }

    /**
     * Taking the data to the `Device Backup` report
     *
     * @param Illuminate\Http\Request $request
     * @return Http\Response
     */
    public function data(Request $request)
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $filteredData = $this->service->data();
        $assets = $filteredData['assets'];


        $start = request('start');
        $data = [];

        if (!empty($assets)) {
            $data = $this->service->getReportData($assets, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }


    /**
     * Taking the data to the `Devices backup` report
     *
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        $filteredData = $this->service->exportData();
        $requiredColumns = config('discovery-tools-export-columns.Kandji.Common');
        $filteredData->chunk(5000, function ($filteredDataChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->service->getReportExportData($filteredDataChunks, 0, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
