<?php

namespace App\Http\Controllers\DiscoveryTools\Kandji;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Models\IntegrationSyncHistory;
use App\Services\DiscoveryTools\Kandji\AllKandjiService;
use Illuminate\Http\Request;

class AllKandjiController extends Controller
{

    protected $allReport;

    public function __construct(AllKandjiService $allReport)
    {
        $this->allReport = $allReport;
    }

    /**
     * Showing the 'All Kandji' Report
     * @return view
     */
    public function index()
    {
        $lastSync = IntegrationSyncHistory::getLastSync(config('integration-sync-histories.kandji'))->first();
        $lastSyncDate = $lastSync?->created_at;

        return view('discovery-tools.kandji.all-report', compact('lastSyncDate'));
    }

    /**
     * Taking the data to the `All Kandji` report
     *
     * @param Illuminate\Http\Request $request
     * @return Http\Response
     */
    public function data(Request $request)
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $filteredData = $this->allReport->data();
        $assets = $filteredData['assets'];


        $start = request('start');
        $data = [];

        if (!empty($assets)) {
            $data = $this->allReport->getReportData($assets, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }


    /**
     * Export the data from the `All Kandji` report
     *
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        $filteredData = $this->allReport->exportData();
        $requiredColumns = config('discovery-tools-export-columns.Kandji.Common');

        $filteredData->chunk(5000, function ($filteredDataChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->allReport->getReportExportData($filteredDataChunks, 0, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
