<?php

namespace App\Http\Controllers\DiscoveryTools\JumpCloud;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\DiscoveryTools\JumpCloud\NotCheckingInNotManagedService;
use Illuminate\Http\Request;

class NotCheckingInNotManagedController extends Controller
{
    public function __construct(protected NotCheckingInNotManagedService $service) {}

    /**
     * Showing the Report
     * @return Http\Response
     */
    public function index()
    {
        return view('discovery-tools.jumpcloud.not-checking-in-not-managed');
    }

    /**
     * Taking the data to the report
     *
     * @param Illuminate\Http\Request $request
     * @return Http\Response
     */
    public function data(Request $request)
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        $filteredData = $this->service->data();
        $assets = $filteredData['assets'];


        $start = request('start');
        $data = [];

        if (!empty($assets)) {
            $data = $this->service->getReportData($assets, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }


    /**
     * Export the data from the `All JumpCloud` report
     *
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        $data = [];
        $datas = collect();
        $filteredData = $this->service->exportData();
        $requiredColumns = config('discovery-tools-export-columns.jumpcloud.DeviceActiveButNotManaged');

        $filteredData->chunk(5000, function ($filteredDataChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->service->getReportExportData($filteredDataChunks, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
