<?php

namespace App\Http\Controllers\DiscoveryTools\JumpCloud;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use Illuminate\Http\Request;
use App\Services\DiscoveryTools\JumpCloud\NotCheckingInManagedService;

class NotCheckingInManagedController extends Controller
{
    public function __construct(protected NotCheckingInManagedService $service) {}

    /**
     * Showing the Devices that are not in teqtivity but in JumpCloud
     * @return Http\Response
     */
    public function index()
    {
        return view('discovery-tools.jumpcloud.not-checking-in-managed');
    }

    /**
     * Taking the data to the `Device Backup` report
     *
     * @param Illuminate\Http\Request $request
     * @return Http\Response
     */
    public function data(Request $request)
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        $filteredData = $this->service->data();
        $assets = $filteredData['assets'];


        $start = request('start');
        $data = [];

        if (!empty($assets)) {
            $data = $this->service->getReportData($assets, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }


    /**
     * Export the data from the `All JumpCloud` report
     *
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        $data = [];
        $datas = collect();
        $filteredData = $this->service->exportData();
        $requiredColumns = config('discovery-tools-export-columns.jumpcloud.Common');

        $filteredData->chunk(5000, function ($filteredDataChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->service->getReportExportData($filteredDataChunks, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
