<?php

namespace App\Http\Controllers\DiscoveryTools\JumpCloud;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\DiscoveryTools\JumpCloud\JumpCloudService;

class JumpCloudController extends Controller
{
    protected $service;

    public function __construct(JumpCloudService $mobileIronService)
    {
        $this->service = $mobileIronService;
    }

    /**
     * Populate filter dropdowns based on search
     * @param Request $request
     * 
     * @return [type]
     */
    public function getFilterFields(Request $request)
    {
        if (!empty($request->search)) {

            $result = $this->service->getFilterFields($request->search, $request->type);

            if (!$result->count()) {
                $result[] = ['id' => '0', 'label' => 'No result found', 'data' => ''];
            }

            return response()->json($result);
        }
    }
}
