<?php

namespace App\Http\Controllers\DiscoveryTools\JumpCloud;

use App\Http\Controllers\Controller;
use App\Services\DiscoveryTools\JumpCloud\CheckingInUserDiscrepancyService;
use App\Http\Responses\ReportJsonResponse;
use Illuminate\Http\Request;

class CheckingInUserDiscrepancyController extends Controller
{
    public function __construct(protected CheckingInUserDiscrepancyService $service) {}

    /**
     * Showing the Mobile Number Report
     * @return Http\Response
     */
    public function index()
    {
        return view('discovery-tools.jumpcloud.checking-in-user-discrepancy');
    }

    /**
     * Taking the data to the report
     *
     * @param Illuminate\Http\Request $request
     * @return Http\Response
     */
    public function data(Request $request)
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        $filteredData = $this->service->data();
        $assets = $filteredData['assets'];


        $start = request('start');
        $data = [];

        if (!empty($assets)) {
            $data = $this->service->getReportData($assets, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }


    /**
     * Export the data from the `All JumpCloud` report
     *
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        $data = [];
        $datas = collect();
        $filteredData = $this->service->exportData();
        $requiredColumns = config('discovery-tools-export-columns.jumpcloud.Common');

        $filteredData->chunk(5000, function ($filteredDataChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->service->getReportExportData($filteredDataChunks, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
