<?php

namespace App\Http\Controllers\DiscoveryTools\JumpCloud;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Models\JumpCloudDevices;
use Illuminate\Http\Request;
use App\Services\DiscoveryTools\JumpCloud\CheckingInNotCreatedService;
use App\Http\Traits\DiscoveryToolsAssetUpdateTrait;
use App\Models\AssetStatus;

class CheckingInNotCreatedController extends Controller
{
    use DiscoveryToolsAssetUpdateTrait;

    public function __construct(protected CheckingInNotCreatedService $service) {}

    /**
     * Showing the Devices that are not in teqtivity but in JumpCloud
     * @return Http\Response
     */
    public function index()
    {
        $assetStatuses = AssetStatus::orderBy('slug')->get();
        return view('discovery-tools.jumpcloud.checking-in-not-created', compact('assetStatuses'));
    }

    /**
     * Taking the data to the `Device Backup` report
     *
     * @param Illuminate\Http\Request $request
     * @return Http\Response
     */
    public function data(Request $request)
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        $filteredData = $this->service->data();
        $assets = $filteredData['assets'];


        $start = request('start');
        $data = [];

        if (!empty($assets)) {
            $data = $this->service->getReportData($assets, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }


    /**
     * Export the data from the `All JumpCloud` report
     *
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        $data = [];
        $datas = collect();
        $filteredData = $this->service->exportData();
        $requiredColumns = config('discovery-tools-export-columns.jumpcloud.Common');

        $filteredData->chunk(5000, function ($filteredDataChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->service->getReportExportData($filteredDataChunks, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }

    /**
     * create
     *
     * @return void
     */
    public function create()
    {
        $jumpcloudAsset = JumpCloudDevices::find(request('jumpcloud-asset-id'));
        $this->CreateAsset($jumpcloudAsset);
        return redirect('/discovery-tools/jumpcloud/checking-in-not-created')->with('message', 'Asset Created Successfully!');
    }
}
