<?php

namespace App\Http\Controllers\DiscoveryTools\Jamf;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Models\IntegrationSyncHistory;
use Illuminate\Http\Request;
use App\Services\DiscoveryTools\Jamf\NotCheckingInNotManaged;

class NotCheckingInNotManagedController extends Controller
{

    protected $jamfService;

    public function __construct(NotCheckingInNotManaged $jamfService)
    {
        $this->jamfService = $jamfService;
    }


    /**
     * Showing the assets that are Deployed - Active, not Managed
     * @return Http\Response
     */
    public function index()
    {
        $lastSync = IntegrationSyncHistory::getLastSync(config('integration-sync-histories.jamf'))->first();
        $lastSyncDate = $lastSync?->created_at;

        return view('discovery-tools.jamf.not-checking-in-not-managed', compact('lastSyncDate'));
    }

    /**
     * Taking the data to the `Deployed - Active, not Managed` report data table
     * @return Http\Response
     */
    public function data(Request $request)
    {
        $filteredData = $this->jamfService->data();

        if (!empty($filteredData['assets'])) {
            $data = $this->jamfService->getReportData($filteredData['assets'], request('start'));
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }

    /**
     * Taking the data for Export
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        $assetsNotCreated =  $this->jamfService->exportData();
        $requiredColumns = config('discovery-tools-export-columns.jamf.Common');

        $assetsNotCreated->chunk(5000, function ($assetChunks) use ($data, $datas, $requiredColumns) {
            $datas->push($this->jamfService->getReportExportData($assetChunks, 0, $data, $requiredColumns));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
