<?php

namespace App\Http\Controllers\DiscoveryTools\Jamf;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\DiscoveryTools\Jamf\JamfService;

class IndexController extends Controller
{
    protected $jamfService;

    public function __construct(JamfService $jamfService)
    {
        $this->jamfService = $jamfService;
    }

    public function getFilterFields(Request $request)
    {
        if(!empty($request->search)) {
            
            $result = $this->jamfService->getFilterFields($request->search, $request->type);
                       
            if (!$result->count()) {
                $result[] = ['id' => '0', 'label' => 'No result found', 'data' => ''];
            }

            return response()->json($result);
        }
    }
}
