<?php

namespace App\Http\Controllers\DiscoveryTools\Intune;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\DiscoveryTools\Intune\AllIntuneService;

class IndexController extends Controller
{
    protected $intuneService;

    public function __construct(AllIntuneService $intuneService)
    {
        $this->intuneService = $intuneService;
    }

    public function getFilterFields(Request $request)
    {
        if (!empty($request->search)) {

            $result = $this->intuneService->getFilterFields($request->search, $request->type);

            if (!$result->count()) {
                $result[] = ['id' => '0', 'label' => 'No result found', 'data' => ''];
            }

            return response()->json($result);
        }
    }
}
