<?php

namespace App\Http\Controllers\DiscoveryTools\ChromeBook;

use App\Http\Controllers\Controller;
use App\Services\DiscoveryTools\Chromebook\NotCheckingInNotManaged;
use App\Http\Responses\ReportJsonResponse;
use App\Models\IntegrationSyncHistory;
use Illuminate\Http\Request;


class NotCheckingInNotManagedController extends Controller
{

    protected $chromebookService;

    public function __construct(NotCheckingInNotManaged $chromebookService)
    {
        $this->chromebookService = $chromebookService;
    }


    /**
     * Showing the assets that are Assigned or Loaned but no Checked in
     * @return Http\Response
     */
    public function index()
    {
        $lastSync = IntegrationSyncHistory::getLastSync(config('integration-sync-histories.chromebook'))->first();
        $lastSyncDate = $lastSync?->created_at;

        return view('discovery-tools.chromebook.not-checking-in-not-managed', compact('lastSyncDate'));
    }

    /**
     * Taking the data to the `AssignedOrLoanedNotCheckedIn` report data table
     * @return Http\Response
     */
    public function data(Request $request)
    {
        $filteredData = $this->chromebookService->data();
        $assets = $filteredData['assets'];

        $start = request('start');
        $data = [];

        if (!empty($assets)) {
            $data = $this->chromebookService->getReportData($assets, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }

    /**
     * Taking the data for Export
     * @return Http\Response
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        $filteredData = $this->chromebookService->exportData();
        $requiredColumns = config('discovery-tools-export-columns.chromebook.DeviceActiveButNotManaged');

        $filteredData->chunk(5000, function ($filteredDataChunks) use ($data, $datas) {
            $datas->push($this->chromebookService->getReportExportData($filteredDataChunks, 0, $data, []));
        });

        return exportToCsv($datas->toArray(), $requiredColumns);
    }
}
