<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\AssetStatus;
use App\Models\AssetType;
use App\User;
use Carbon\Carbon;
use Facades\App\Repositories\Dashboard\DashboardRepository;
use App\Services\Dashboard\DashboardService;
use Illuminate\Support\Facades\Auth;

/**
 * Controller class that handles the functionality and operations related to the Inventory Dashboard. 
 */
class InventoryDashboardController extends Controller
{
    protected $dashboardService;

    public function __construct(DashboardService $dashboardService)
    {
        $this->dashboardService = $dashboardService;
    }

    /**
     * Index function of InventoryDashboardController
     * @return [type]
     */
    public function index()
    {
        $user = User::with('userType')->find(Auth::id());
        if ($user->hasRole('Employee')) {
            return redirect(route('my-teq-assets'));
        }

        $count = $this->dashboardService->getAssetCounts();
        $assetHealthCount = $this->dashboardService->getAssetHealthCounts();

        $assetStatuses = AssetStatus::withCount('assets')->orderBy('slug')->get();
        foreach ($assetStatuses as $status) {
            $count[$status->slug] = $status->assets_count;
        }

        $months = generateRecentYearMonthsArrayWithMonthNumber();

        $monthNames = generateRecentMonthsArray();

        $assetLineGraphData = DashboardRepository::getAssetCreated($months);

        $regionCount = $this->dashboardService->getAssetsInRegionCount();

        $assetTypes = AssetType::withCount('assets')->get();

        $computersWidgetData = $this->dashboardService->getcomputerWidgetdata();

        return view('dashboard.inventory-dashboard', compact('count', 'assetHealthCount', 'monthNames', 'assetLineGraphData', 'regionCount', 'assetTypes', 'assetStatuses', 'computersWidgetData'));
    }
}
