<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\ActiveVulnerabilitiesPerWeek;
use Facades\App\Services\Dashboard\ComplianceDashboard;
use Illuminate\Support\Facades\Artisan;

class ComplianceDashboardController extends Controller
{
    /**
     * index
     *
     * @return void
     */
    public function index()
    {
        $widgetNames = ["Lost/Stolen, not Locked", "Not in MDM", "EOL Wiped without CODD", "Sensor Detected"];

        foreach ($widgetNames as $widget) {
            $WidgetData[$widget] = ComplianceDashboard::complianceDashboardData($widget);
        }
        $WidgetData['Vulnerabilities Found'] = ComplianceDashboard::getVulnerabilityData();
        $WidgetData['EOL Wiped checking in'] = ComplianceDashboard::getEOLWipedCheckingInData();
        $totalOpenVulnerabilitiesInLastPeriod = ActiveVulnerabilitiesPerWeek::get()->toArray();
        $openVulnerabilitiesPerPeriod = array_map(function ($item) {
            $item['period'] = parse_date_from_db_date($item['start_date']) . ' - ' . parse_date_from_db_date($item['end_date']);
            return $item;
        }, $totalOpenVulnerabilitiesInLastPeriod);

        return view('dashboard.compliance-index', compact('WidgetData', 'openVulnerabilitiesPerPeriod'));
    }

    /**
     * Refreshes asset count in 1st widget
     * @return [type]
     */
    public function refreshAssetsCount()
    {
        Artisan::call('EOLWipedCheckingInAssetsCount:update');
        return redirect()->route('compliance-dashboard')->with('message', 'EOL Wiped checking in assets count updated successfully.');
    }

    /**
     * Refreshes Vulnerability count for graph
     * @return object
     */
    public function refreshVulnerabilityCount()
    {
        Artisan::call('ActiveVulnerabilitiesCountPerWeek:update');

        return redirect()->route('compliance-dashboard')->with('message', 'Open vulnerabilities count per week updated successfully.');
    }
}
