<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Where to redirect users after resetting their password.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Handle the response after a successful password reset.
     *
     * This method redirects the user to the login page with a status message,
     * instead of automatically logging them in. This is useful in applications
     * where manual login after password reset is required for security or
     * workflow purposes.
     *
     * @param  \Illuminate\Http\Request  $request  The incoming HTTP request instance.
     * @param  string  $response  The response message key from the password broker (e.g., 'passwords.reset').
     * @return \Illuminate\Http\RedirectResponse A redirect response to the login route with a status flash message.
     */
    protected function sendResetResponse(Request $request, $response)
    {
        auth()->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        if ($request->wantsJson()) {
            return new JsonResponse(['message' => trans($response)], 200);
        }

        return redirect()->intended('login')->with('status', trans($response));
    }
}
