<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    protected $maxAttempts = 5; // Number of login attempts allowed.
    protected $decayMinutes = 1; // Time in minutes until the login attempts are reset.

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function authenticated(Request $request, $user)
    {
        if ($user->hasPermissionTo('IT Assets View')) {
            return redirect(route('assets.index'));
        }

        return redirect(route('my-teq-assets'));
    }

    protected function credentials(Request $request)
    {
        return ['email' => $request->email, 'password' => ($request->password)];
    }

    public function emailVerify(Request $request)
    {
        $token = $request->email_token;
        if (!$token) {
            return  redirect('/login')->withErrors(['email' => 'Email Verification Token not provided!']);
        }

        $user = User::whereEmail($request->email)->where('email_token', $token)->first();


        if (!$user) {
            return  redirect('/login')->withErrors(['flash-error' => 'Invalid Email Verification Token!']);
        }

        Auth::login($user);
        if ($user->hasPermissionTo('IT Assets View')) {
            return redirect(route('assets.index'));
        }

        return redirect(route('my-teq-assets'));
    }
}
