<?php

namespace App\Http\Controllers\AssetsHealth;

use App\Http\Controllers\Controller;
use App\Services\AssetsHealth\AssetsHealthReportService;
use Illuminate\Http\Request;
use Validator;

class SendEmailPdfReportController extends Controller
{
    /**
     * Constructs a new instance of the class.
     *
     * @return void
     */
    public function __construct(
        protected AssetsHealthReportService $assetHealthReportService,
    ) {

    }

    /**
     * Send the asset health PDF report via email.
     *
     * @param  \Illuminate\Http\Request  $request  The HTTP request containing the email data.
     *
     * @return \Illuminate\Http\JsonResponse  The JSON response indicating the success or failure of the email sending operation.
     */
    public function sendEmail(Request $request)
    {
        $requestData = $request->except('_token');

        $validator = Validator::make($requestData, [
            'users' =>  'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['success' => false, 'errors' => $validator->errors()], 422);
        }

        if ($this->assetHealthReportService->sendEmailAssetHealthPdfReport($requestData)) {
            return response()->json([
                'success' => true,
                'message' => 'Email sent successfully',
            ], 200);
        }

        return response()->json([
            'success' => false,
            'message' => 'Email not sent',
        ], 200);
    }

}
