<?php

namespace App\Http\Controllers\AssetsHealth;

use App\Http\Controllers\Controller;
use App\Models\AssetHealthReportSchedule;
use Illuminate\Http\Request;
use Validator;

class ScheduleAssetHealthReportController extends Controller
{
    /**
     * Constructs a new instance of the class.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Schedule the asset health report.
     *
     * @param  \Illuminate\Http\Request  $request  The HTTP request containing the schedule data.
     *
     * @return \Illuminate\Http\JsonResponse  The JSON response indicating the success or failure of the scheduling operation.
     */
    public function scheduleReport(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'weekly_day' =>  'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['success' => false, 'errors' => $validator->errors()], 422);
        }

        $schedule = AssetHealthReportSchedule::first()->update([
            'weekly_day' => $request->weekly_day
        ]);


        if ($schedule) {
            return response()->json([
                'success' => true,
                'message' => 'Schedule updated successfully.',
            ], 200);
        }

        return response()->json([
            'success' => false,
            'message' => 'Schedule not updated.',
        ], 200);
    }
}
