<?php

namespace App\Http\Controllers\AssetsHealth;

use App\Http\Controllers\Controller;
use App\Exports\AssetHealthReport;
use App\Models\AssetHealthTests;
use App\Services\AssetsHealth\AssetsHealthDashboardService;

class AssetsHealthReportExcelExportController extends Controller
{
    /**
     * Constructs a new instance of the class.
     *
     * @param  \App\Services\AssetsHealthDashboardService  $assetHealthDashboardService  The service for managing assets health dashboard.
     *
     * @return void
     */
    public function __construct(
        protected AssetsHealthDashboardService $assetHealthDashboardService,
    ) {
    }

    /**
     * Download the asset health report in Excel format.
     *
     * @return \Illuminate\Http\Response The response containing the downloaded Excel file.
     */
    public function download()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();

        $testReports = [];
        $testDetailReports = [];

        $allCategories = $this->assetHealthDashboardService->getCategories();

        foreach ($allCategories as $category) {
            $allTests = $this->assetHealthDashboardService->getHealthReportsByTests($category->id)->get();

            $testReports[$category->slug]['category'] = $category;
            $testReports[$category->slug]['tests'] = $allTests;

            foreach ($allTests as $test) {
                $testDetails = $this->assetHealthDashboardService->getTestReportDetailsForExcel($test->id);

                $testData = AssetHealthTests::find($test->test_id) ?? null;
                $testDetailReports[$test->id]['test'] = $testData;

                $reportData = [];

                foreach ($testDetails as $key => $testDetail) {
                    $reportData[] = $this->assetHealthDashboardService->getNestedDataForExcel($testDetail, $key + 1, $testData);
                }

                $testDetailReports[$test->id]['reports'] = $reportData;
            }
        }

        return (new AssetHealthReport($testReports, $testDetailReports))->download('asset-health-report.xlsx');
    }
}
