<?php

namespace App\Http\Controllers\Assets;

use App\Http\Controllers\Controller;
use App\Models\AssetStatus;
use App\Services\Asset\AssetStatusService;
use App\Models\Asset;
use App\Http\Requests\AssetStatusUpdateRequest;
use App\Services\Asset\UpdateStatusService;

class UpdateAssetStatusController extends Controller
{

    public function __construct(protected UpdateStatusService $updateStatusService, protected AssetStatusService $assetStatusService) {}

    /**
     * Updates the status of the asset.
     *
     * @param AssetStatusUpdateRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function updateStatus(AssetStatusUpdateRequest $request)
    {
        $assetId = $request->asset_id;
        $statusId = $request->asset_status_id;
        $status = AssetStatus::getName($statusId)->first()->name;

        $asset = Asset::with('assetStatus', 'childrenAsset', 'location')->where('id', $assetId);
        $check = $this->assetStatusService->canBeUpdatedTo($status, $asset);

        if ($check === false) {
            return back()->with('error', 'Do not qualify! The asset cannot be updated to the status picked.');
        }

        // Checks if the location of asset is frozen or not.
        $check = $this->assetStatusService->validateFromLocationFreeze($asset);

        if ($check === false) {
            return back()->with('error-message', "Do not qualify! cannot update the status of asset from frozen location.");
        }

        $inputData = $request->all();
        $inputData['status_name'] = $status;

        $this->updateStatusService->updateStatus($inputData);

        return redirect()->back()->with('message', 'The asset has been updated.');
    }
}
