<?php

namespace App\Http\Controllers\Assets\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ApiCredential;
use App\Services\Integrations\Tickets\Zendesk\OAuthWrapperZendesk;

class ZendeskApiCredentialsController extends Controller
{
    private $ticketIntegration;
    public function __construct(OAuthWrapperZendesk $ticketIntegration)
    {
        $this->ticketIntegration = $ticketIntegration;
    }

    public function index()
    {
        $apiCredential = ApiCredential::where('slug', 'zendesk')->first();

        if ($apiCredential == null) {
            return redirect('/zendesk/create');
        }

        $status = 0;

        $authorizedUser = $this->ticketIntegration->getAuthorizedUser();
        if (isset($authorizedUser['id'])) {
            $status = 1;
        }

        return view('settings.zendesk.index', compact('apiCredential', 'status'));
    }

    public function create()
    {
        $apiCredential = ApiCredential::where('slug', 'zendesk')->first();

        if ($apiCredential) {
            return redirect('zendesk/' . $apiCredential->id . '/edit');
        }
        return view('settings.zendesk.create');
    }


    public function store(Request $request)
    {
        $request->validate([
            'url' => ['required', 'url'],
            'user_name' => ['required'],
            'key' => ['required'],
        ]);

        try {
            ApiCredential::create(
                [
                    'api_name' => 'Zendesk',
                    'slug' => 'zendesk',
                    'url' => $request->url,
                    'user_name' => $request->user_name,
                    'key' => $request->key,

                ]
            );

            return redirect('/zendesk')->withMessage('Zendesk API credentials created successfully.');
        } catch (\Exception $e) {
            logMessage("Zendesk credential create failed with error " . $e->getMessage(), 'error');

            return redirect('/zendesk')->with('error', 'Operation failed!');
        }
    }

    public function edit($id)
    {
        $credential = ApiCredential::where('id', $id)->first();

        return view('settings.zendesk.edit', compact('credential'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'url' => ['required', 'url'],
            'user_name' => ['required'],
        ]);

        try {
            $credential = ApiCredential::where('id', $id)->first();

            $credential->update(
                [
                    'url' => $request->url,
                    'user_name' => $request->user_name,
                    'key' => $request->key ?: $credential->key,

                ]
            );

            return redirect('/zendesk')->withMessage('Zendesk API credentials updated successfully.');
        } catch (\Exception $e) {
            logMessage("Zendesk credential update failed with error " . $e->getMessage(), 'error');

            return redirect('/zendesk')->with('error', 'Operation failed!');
        }
    }
}
