<?php

namespace App\Http\Controllers\Assets\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ApiCredential;
use Exception;

class UpsTrackingController extends Controller
{
    public function index()
    {

        $credentials = ApiCredential::where('slug', 'ups_tracking')->first();

        if ($credentials) {
            // $status = $this->service->checkApiConnection();

            return view('settings.ups.index', compact('credentials'));
        }

        return redirect()->route('ups-tracking.create');
    }

    public function create()
    {
        return view('settings.ups.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'user_name' => 'required',
            'password' => 'required',
            'url' => 'required',
            'key' => 'required',
        ]);

        ApiCredential::create([
            'api_name'  => 'UPS Tracking',
            'slug'      => 'ups_tracking',
            'url'       => $request->url,
            'user_name' => $request->user_name,
            'key'       => $request->key,
            'password'  => $request->password,
        ]);

        return redirect()->route('ups-tracking.index')->with('message', __('message.created'));
    }

    public function edit($id)
    {
        try {
            $credential = ApiCredential::findOrFail($id);
            return view('settings.ups.edit', compact('credential'));
        } catch (Exception $e) {
            return redirect(route('ups-tracking.index'))->with('error', 'Something went wrong. Try again later');
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $credential = ApiCredential::findOrFail($id);
            $updateData = [
                'url'       => $request->url,
                'user_name' => $request->user_name,
                'key'       => $request->key ? $request->key : $credential->key,
                'password'  => $request->password ? $request->password : $credential->password,
            ];
            $credential->update($updateData);
            return redirect(route('ups-tracking.index'))->with('message', 'Credentials updated successfully');
        } catch (Exception $e) {
            return redirect(route('ups-tracking.index'))->with('error', 'Something went wrong. Try again later');
        }
    }
}
