<?php

namespace App\Http\Controllers\Assets\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ApiCredential;
use App\Services\Integrations\Asn\AsnShiIntegration;
use Artisan;

class ShiController extends Controller
{
    public function __construct(AsnShiIntegration $service)
    {
        $this->service = $service;
    }

    public function index()
    {
        $credentials = ApiCredential::where('slug', 'asn_shi')->first();
        $status = 0;
        if ($credentials) {
            $status = $this->service->checkConnection();

            return view('settings.shi.index', compact('credentials', 'status'));
        }

        return redirect()->route('asn-shi-api-settings.create');
    }

    public function create()
    {
        $credential = ApiCredential::where('slug', 'asn_shi')->first();
        if ($credential) {
            return redirect('asn-shi-api-settings/' . $credential->id . '/edit');
        }
        return view('settings.shi.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'user_name' => 'required',
            'password' => 'required',
            'url' => 'required',
        ]);

        ApiCredential::create([
            'api_name'  => 'ASN SHI',
            'slug'      => 'asn_shi',
            'url'       => $request->url,
            'user_name' => $request->user_name,
            'password'  => $request->password,
        ]);

        return redirect()->route('asn-shi-api-settings.index')->with('message', __('message.created'));
    }

    public function edit($id)
    {
        $credential = ApiCredential::find($id);

        return view('settings.shi.edit', compact('credential'));
    }

    public function update(Request $request, $id)
    {
        $credential = ApiCredential::find($id);

        $credential->update([
            'url'       => $request->url,
            'user_name' => $request->user_name ?? $credential->user_name,
            'password'  => $request->password ?? $credential->password,
        ]);

        return redirect()->route('asn-shi-api-settings.index')->with('message', __('message.updated'));
    }
}
