<?php

namespace App\Http\Controllers\Assets\Settings;

use App\Http\Controllers\Controller;
use App\Models\OperatingSystemComplianceSettings;
use App\Services\OperatingSystemCompliance\OSComplianceService;
use Illuminate\Http\Request;

class OperatingSystemComplianceController extends Controller
{
    protected $service;

    public function __construct() {
        $this->service = new OSComplianceService;
    }

    public function index()
    {
        $data = $this->service->getSettingsFilters();

        return view('settings.operating-system-compliance',['data' => $data]);

    }

    public function store(Request $request)
    {
        $data = $this->service->getInputDataFromSettings($request->all());
        foreach ($data as $attributes) {
            $osComplianceSettings  = OperatingSystemComplianceSettings::where('device_type',$attributes['device_type'])->first();
            if (!$osComplianceSettings) {
                OperatingSystemComplianceSettings::create($attributes);
                continue;
            }
            $osComplianceSettings->update([
                'os_version' => $attributes['os_version'] ?? NULL,
                'os_platform' => $attributes['os_platform'] ?? NULL,
            ]);
        }
        return redirect()->route('operating-system-compliance.index')->with('message', 'Settings Updated');
    }

}
