<?php

namespace App\Http\Controllers\Assets\Settings;

use App\Http\Controllers\Controller;
use App\Http\Requests\DepartmentHardwareRequest;
use App\Models\DepartmentHardwareMapping;
use App\Models\TechnicalSpecs;
use App\Services\HardwarekitService;
use App\Repositories\HardwarekitRepository as DepartmentHardwareRepo;

class HardwarekitController extends Controller
{
    /**
     * Constructor for the DepartmentController
     */
    public function __construct(protected HardwarekitService $hardwarekitService, protected DepartmentHardwareRepo $hardwarekitRepo)
    {
    }

    /**
     * List all the department & hardware mapping
     */
    public function index()
    {
        $departments = $this->hardwarekitRepo->getDepartments();
        $hardwareStandards = $this->hardwarekitRepo->getHardwareStandards();
        $departmentHardwares = $this->hardwarekitService->getDepartmentHardwareKitData()->toArray();

        return view('settings.departments.hardware-kits', compact('departments', 'hardwareStandards', 'departmentHardwares'));
    }
    /**
     *update the mapping harwares for the departments
     */
    public function addHardwareKits(DepartmentHardwareRequest $request)
    {
        $postData = $request->except('_token', 'action');

        if ($request->input('action') === 'update') {
            $this->hardwarekitService->deleteDepartmentHardwares($postData['department_id']);
        }
        // dd($postData);
        $this->hardwarekitService->updateDepartmentHardwares($postData);
        return redirect()->to('hardware-kits')->with('message', 'Hardware kits updated successfully.');
    }
    /**
     * filter for the mapped hardwares of the departments
     */
    public function search()
    {
        $departmentHardwares = $this->hardwarekitService->getDepartmentHardwareKitData()->toArray();
        $view['hardwaremapping'] = view('settings.departments.partials.department-hardware-mapping', compact('departmentHardwares'))->render();
        return response()->json($view);
    }

    /**
     * Gets the hardware kits of the department
     * @param mixed $departmentId
     * 
     * @return [type]
     */
    public function getHarwareKitsByDepartment($departmentId)
    {
        if (!$departmentId) {
            return false;
        }

        $hardWareKits = DepartmentHardwareMapping::where('department_id', $departmentId)->get();
        $hardwareStandards = $this->hardwarekitRepo->getHardwareStandards();
        $techSpecs = TechnicalSpecs::whereIn('make_and_model_id', $hardWareKits->pluck('make_and_model_id')->toArray())->get();
        $view['hardWareKits'] = view('settings.departments.partials.hardware-mapping-edit-dropdowns', compact('hardWareKits', 'hardwareStandards', 'techSpecs'))->render();
        return response()->json($view);
    }
}
