<?php

namespace App\Http\Controllers\Assets\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ApiCredential;
use App\Services\Integrations\Tickets\FreshService\FreshServiceIntegration;
use Exception;

class FreshServiceController extends Controller
{
    protected $ticketIntegration;

    /**
     * Constructor for Fresh Service Controller
     *
     * @param object FreshServiceIntegration $ticketIntegration
     */
    public function __construct(FreshServiceIntegration $ticketIntegration)
    {
        $this->apiCredential = ApiCredential::where('slug', 'freshservice')->first();
        $this->ticketIntegration = $ticketIntegration;
    }

    /**
     * List the API details of Fresh Service
     *
     * @return object
     */
    public function index()
    {
        $apiCredential      = $this->apiCredential;

        if ($apiCredential == null) {
            return redirect('/freshservice/create');
        }

        $status = $this->ticketIntegration->checkConnection();


        return view('settings.freshservice.index', compact('apiCredential', 'status'));
    }

    /**
     * create API Credentials for Fresh Service
     *
     * @return object
     */
    public function create()
    {
        return view('settings.freshservice.create');
    }

    /**
     * Edit API Credentials for Fresh Service
     *
     * @return object
     */
    public function edit()
    {
        $credential = $this->apiCredential;

        return view('settings.freshservice.edit',  compact('credential'));
    }


    /**
     * save new
     *
     * @param  mixed $request
     * @param  mixed $id
     * @return void
     */
    public function store(Request $request)
    {
        $request->validate([
            'url' => ['required', 'url'],
            'key' => ['required'],
        ]);

        try {
            ApiCredential::create(
                [
                    'api_name' => 'Freshservice API',
                    'url' => $request->url,
                    'key' => $request->key,
                    'slug' => 'freshservice',
                ]
            );

            return redirect('/freshservice')->with('message', 'Credentials added successfully.');
        } catch (Exception $e) {
            logMessage("Freshservice credential create failed with error " . $e->getMessage(), 'error');
            return redirect('/freshservice')->with('error', 'Operation failed!');
        }
    }

    /**
     * update
     *
     * @param  mixed $request
     * @param  mixed $id
     * @return void
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'url' => ['required', 'url'],
        ]);

        try {
            $credential = ApiCredential::findOrFail($id);
            ApiCredential::where('id', $id)->update(
                [
                    'url' => $request->url,
                    'key' => $request->key ? $request->key : $credential->key,
                    'slug' => 'freshservice',
                ]
            );

            return redirect('/freshservice')->with('message', 'Credentials updated successfully.');
        } catch (Exception $e) {
            logMessage("Freshservice credential update failed with error " . $e->getMessage(), 'error');

            return redirect('/freshservice')->with('error', 'Operation failed!');
        }
    }
}
