<?php

namespace App\Http\Controllers\Assets\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\DataTableJsonResponse;
use App\Services\FailedTicketHistoryService;

class FailedTicketController extends Controller
{

    public function __construct(protected FailedTicketHistoryService $historyService)
    {
    }

    /**
     * index function.
     *
     * @return mixed
     */
    public function index()
    {
        return view('settings.history.failed-tickets-history');
    }

    /**
     * data function.
     *
     * @param Request $request
     */
    public function data(Request $request)
    {
        $filteredData   = $this->historyService->data();
        $failedTickets  =  $filteredData['failedTicketHistory'];
        $totalData      = $filteredData['count'];

        $start  = request('start');
        $data   = [];

        if (!empty($failedTickets)) {
            $data = $this->historyService->getNestedData($failedTickets, $start, $data);
        }
        
        return new DataTableJsonResponse($request->input('draw'), $data, $totalData);
    }

    /**
     * Export data and handle the export process.
     *
     * @return Some_Return_Value
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();

        $data = [];
        $datas = collect();

        $failedTicket = $this->historyService->getExportData();

        $datas->push($this->historyService->getExportNestedData($failedTicket, 1, $data));

        return exportToCsv($datas->toArray());
    }
}
