<?php

namespace App\Http\Controllers\Assets\Settings\DiscoveryTools;

use App\Http\Controllers\Controller;
use App\Models\ApiCredential;
use App\Services\Integrations\WorkspaceOneApi;
use Illuminate\Http\Request;

class WorkspaceOneController extends Controller
{
    public $workspaceOneApi;

    public function __construct(WorkspaceOneApi $workspaceOneApi)
    {
        $this->workspaceOneApi = $workspaceOneApi;
    }

    public function index()
    {
        $credential = ApiCredential::where('slug', 'airwatch')->first();

        if ($credential) {
            $status = 0;
            /*if ($this->workspaceOneApi->apiConnect()) {
                $status = 1;
            }*/
            return view('settings.discovery-tools.workspace-one.workspace-one', compact('credential', 'status'));
        }
        return redirect(route('workspace-one.create'));
    }

    public function create()
    {
        $credential = ApiCredential::where('slug', 'airwatch')->first();
        if ($credential) {
            return redirect('workspace-one/' . $credential->id . '/edit');
        }
        return view('settings.discovery-tools.workspace-one.workspace-one-create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'url' => ['required', 'url'],
            'user_name' => ['required'],
            'password' => ['required'],
            'api_key' => ['required'],
        ]);

        ApiCredential::create([
            'api_name' => 'Workspace ONE',
            'slug' => 'airwatch',
            'url' => $request->url,
            'user_name' => $request->user_name,
            'password' => $request->password,
            'key' => $request->api_key,
        ]);

        return redirect('/workspace-one')->withMessage('Credentials added successfully.');
    }

    public function edit($workspaceOne)
    {
        $credential = ApiCredential::find($workspaceOne);
        return view('settings.discovery-tools.workspace-one.workspace-one-edit', compact('credential'));
    }

    public function update(Request $request, $workspaceOne)
    {
        $request->validate([
            'url' => 'required',
            'user_name' => 'required',
        ]);

        $credential = ApiCredential::find($workspaceOne);
        $updateData = [
            'url' => $request->url,
            'user_name' => $request->user_name,
        ];

        if ($request->password) {
            $updateData['password'] = $request->password;
        }

        if ($request->api_key) {
            $updateData['key'] = $request->api_key;
        }

        $credential->update($updateData);

        return redirect('/workspace-one')->withMessage('Credentials updated successfully.');
    }
}
