<?php

namespace App\Http\Controllers\Assets\Settings\DiscoveryTools;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ApiCredential;
use Facades\App\Services\Integrations\JamfIntegration;
use Crypt;
use Exception;
use Illuminate\Support\Facades\Artisan;

class JamfController extends Controller
{
    public function index()
    {
        $credentials = ApiCredential::where('slug', 'jamf')->first();
        if ($credentials) {
            $status = JamfIntegration::oauth();
            return view('settings.discovery-tools.jamf.index', compact('credentials', 'status'));
        }

        return redirect()->route('jamf.create');
    }

    public function create()
    {
        $credential = ApiCredential::where('slug', 'jamf')->first();
        if ($credential) {
            return redirect('jamf/' . $credential->id . '/edit');
        }
        return view('settings.discovery-tools.jamf.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'user_name' => 'required',
            'password' => 'required',
            'url' => 'required',
        ]);
        try {
            ApiCredential::create([
                'api_name'  => 'Jamf',
                'slug'      => 'jamf',
                'url'       => $request->url,
                'user_name' => $request->user_name,
                'password'  => $request->password,
            ]);

            return redirect()->route('jamf.index')->with('message', __('message.created'));
        } catch (Exception $e) {
            return redirect(route('jamf.index'))->with('error', 'Something went wrong. Try again later');
        }
    }

    public function edit($id)
    {
        try {
            $credential = ApiCredential::findOrFail($id);
            return view('settings.discovery-tools.jamf.edit', compact('credential'));
        } catch (Exception $e) {
            return redirect(route('jamf.index'))->with('error', 'Something went wrong. Try again later');
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $credential = ApiCredential::findOrFail($id);

            $credential->update([
                'url'       => $request->url,
                'user_name' => $request->user_name,
                'password'  => $request->password ?: $credential->password,
            ]);

            return redirect()->route('jamf.index')->with('message', __('message.updated'));
        } catch (Exception $e) {
            return redirect(route('jamf.index'))->with('error', 'Something went wrong. Try again later');
        }
    }
    public function connect()
    {
        try {
            $client = JamfIntegration::oauth();
            if ($client) {
                return redirect()->route('jamf.index')->with('message', 'Connected successfully');
            }

            return redirect()->route('jamf.index')->withError('Connection failed');
        } catch (Exception $e) {
            return redirect(route('jamf.index'))->with('error', 'Something went wrong. Try again later');
        }
    }

    /**
     * processing Jamf Sync 
     */
    public function manualSync()
    {
        try {
            $client = JamfIntegration::oauth();
            if ($client) {

                // Artisan::queue('JamfDataSync:run', [
                //     '--queue' => 'default'
                // ])
                // ->onConnection('database')
                // ->onQueue('commands');

                Artisan::call('JamfDataSync:run');

                return response()->json(array('status' => 'success', 'message' => Artisan::output()));
            }

            return response()->json(array('status' => 'error', 'message' => 'Connection failed'));
        } catch (Exception $e) {
            return response()->json(array('status' => 'error', 'message' => 'Something went wrong. Try again later'));
        }
    }
}
