<?php

namespace App\Http\Controllers\Assets\Settings;

use App\Events\BulkUpdates;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Facades\App\Models\MakeAndModel;
use Facades\App\Models\Manufacturer;
use App\Models\AssetType;
use App\Models\AssetTypeAttribute;
use App\Models\AssetHistory;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class AttributesController extends Controller
{

    public function index()
    {
        $hardwares = MakeAndModel::getAll();
        $assettypes = AssetType::allWithoutComputerAccessories()->pluck('name', 'name');
        $attributes = AssetTypeAttribute::join('asset_types', 'asset_types.id', '=', 'asset_type_attributes.asset_type_id')
            ->select('asset_types.name', 'asset_type_attributes.*')
            ->orderBy('asset_types.name')->get();
        return view('settings.attributes.attribute', compact('hardwares', 'assettypes', 'attributes'));
    }

    public function store()
    {

        $this->validate(request(), [
            'asset_type_id' => 'required',
            'attribute_name' => 'required'
        ]);

        foreach (request('asset_type_id') as  $typeid) {
            AssetTypeAttribute::firstOrCreate([
                'asset_type_id' => $typeid,
                'attribute_name' => request('attribute_name'),
            ]);

            $assetType = AssetType::where('id', $typeid)->first();
            $description = __('history.AssetAttributeCreated', [
                'assetAttribute' => request('attribute_name'),
                'assetType' => $assetType->name
            ]);
            $assetHistory = [
                'user_id' => Auth::id(),
                'action' => 'assetAttribute_created',
                'description' => $description,
                'created_at'  => Carbon::now()->format('Y-m-d H:i:s'),
                'updated_at'  => Carbon::now()->format('Y-m-d H:i:s'),
            ];
            event(new BulkUpdates($assetHistory));
        }

        return redirect('/asset-attributes');
    }

    public function update()
    {
        $assetTypeAttribute = AssetTypeAttribute::findOrFail(request('id'));
        $oldAssetAttributeValue = $assetTypeAttribute->attribute_name;

        $assetType = AssetType::where('id', $assetTypeAttribute->asset_type_id)->first();

        $assetTypeAttribute->update([
            'attribute_name' => request('attribute_name'),
        ]);

        $description = __('history.AssetAttributeUpdated', [
            'oldAssetAttributeValue' => $oldAssetAttributeValue,
            'newAssetAttributeValue' => request('attribute_name'),
            'assetType' => $assetType->name
        ]);
        $assetHistory = [
            'user_id' => Auth::id(),
            'action' => 'assetAttribute_updated',
            'description' => $description,
            'created_at'  => Carbon::now()->format('Y-m-d H:i:s'),
            'updated_at'  => Carbon::now()->format('Y-m-d H:i:s'),
        ];
        event(new BulkUpdates($assetHistory));

        return response()->json('success');
    }


    public function destroy()
    {
        $attribute = AssetTypeAttribute::findOrFail(request('id'));
        $assetAttributeValue = $attribute->attribute_name;
        $assetType = AssetType::where('id', $attribute->asset_type_id)->first();

        if (count($attribute->assetTypeAttributeValue)) {
            return response()->json('error');
        }
        $attribute->delete();

        $description = __('history.AssetAttributeDeleted', [
            'assetAttributeValue' => $assetAttributeValue,
            'assetType' => $assetType->name
        ]);
        $assetHistory = [
            'user_id' => Auth::id(),
            'action' => 'assetAttribute_deleted',
            'description' => $description,
            'created_at'  => Carbon::now()->format('Y-m-d H:i:s'),
            'updated_at'  => Carbon::now()->format('Y-m-d H:i:s'),
        ];
        event(new BulkUpdates($assetHistory));
        return response()->json("Deleted Successfully");
    }

    public function ajax()
    {

        if (request('action') == 'edit') {
            return $this->update();
        } elseif (request('action') == 'delete') {
            return $this->destroy();
        }

        return response()->json(true);
    }
}
