<?php

namespace App\Http\Controllers\Assets\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AssetType;
use App\Models\AssetTab;
use Cache;

class AssetTabController extends Controller
{

    public function index()
    {
        $assetTypes = AssetType::orderBy('slug')->get();
        $assetTabs = AssetTab::get();

        return view('settings.asset-tabs', compact('assetTypes', 'assetTabs'));
    }

    public function store()
    {
        $assetTypes = AssetType::get();
        $assetTabs = AssetTab::get();

        foreach ($assetTypes as $type) {
            foreach ($assetTabs as $tab) {
                $type->assetTabs()->detach($tab->id);

                if(request($tab->slug.'-'.$type->slug)) {
                    $type->assetTabs()->attach($tab->id);
                }
            }
        }

        Cache::forget('regular-asset-types');

        return redirect('asset-tabs')->with('message', __('message.asset_tabs_updated'));
    }

}
