<?php

namespace App\Http\Controllers\Assets;

use App\Http\Controllers\Controller;
use App\Models\Asset;
use App\Models\Manufacturer as ModelsManufacturer;
use Carbon\Carbon;
use Facades\App\Repositories\HardwareStandards;
use Facades\App\Repositories\TechnicalSpecs;

class SearchController extends Controller
{
    public function search()
    {
        $category = request('category');
        $assetType = request('asset_type');
        $status = request('status');
        $carrier = request('carrier');
        $makeAndModel = request('make_and_model');
        $technicalSpec = request('technical_spec');
        $location = request('location');
        $user = request('user');
        $assetAge = request('asset_age_value');
        $ageUnit = request('asset_age_unit');
        $leaseStartDateFrom = request('lease_start_date_from')[0];
        $leaseStartDateTo = request('lease_start_date_to')[0];
        $leaseEndDateFrom = request('lease_end_date_from')[0];
        $leaseEndDateTo = request('lease_end_date_to')[0];
        $dateDeployedFrom = request('date_deployed_from')[0];
        $dateDeployedTo = request('date_deployed_to')[0];
        $loanerReturnDateFrom = request('loaner_return_date_from')[0];
        $loanerReturnDateTo = request('loaner_return_date_to')[0];
        $lostDateFrom = request('lost_date_from')[0];
        $lostDateTo = request('lost_date_to')[0];
        $building = request('building');

        $assetsAll = Asset::with('location', 'user', 'assetType', 'assetType.assetTabs', 'makeAndModel.manufacturer', 'technicalSpec', 'assetStatus', 'parentAsset', 'latestAssetHistory');

        $assets = $assetsAll->regularAsset();

        if ($category) {
            if ($category == 'mobile') {
                $assets = $assetsAll->mobileAsset();
            }
        }

        if ($assetType) {
            $assets = $assets->whereIn('asset_type_id', $assetType);
        }

        if ($status) {
            $assets = $assets->whereIn('asset_status_id', $status);
        }

        if ($carrier) {
            $assets = $assets->whereIn('carrier_id', $carrier);
        }

        if ($makeAndModel) {
            $assets = $assets->whereIn('make_and_model_id', $makeAndModel);
        }

        if ($technicalSpec) {
            $assets = $assets->whereIn('technical_spec_id', $technicalSpec);
        }

        if ($location) {
            $assets = $assets->whereIn('location_id', $location);
        }

        if ($building) {
            $assets = $assets->whereIn('location_id', $building);
        }

        if ($user) {
            $assets = $assets->whereIn('user_id', $user);
        }

        if ($assetAge) {
            if ($ageUnit == 'day') {
                $date = Carbon::now()->subDays($assetAge);
            }

            if ($ageUnit == 'month') {
                $date = Carbon::now()->subMonths($assetAge);
            }

            if ($ageUnit == 'year') {
                $date = Carbon::now()->subYears($assetAge);
            }

            $assets = $assets->where('created_at', '<=', $date);
        }

        if ($leaseStartDateFrom) {
            $assets = $assets->where('lease_start_date', '>=', convert_to_db_date($leaseStartDateFrom));
        }

        if ($leaseStartDateTo) {
            $assets = $assets->where('lease_start_date', '<=', convert_to_db_date($leaseStartDateTo));
        }

        if ($leaseEndDateFrom) {
            $assets = $assets->where('lease_end_date', '>=', convert_to_db_date($leaseEndDateFrom));
        }

        if ($leaseEndDateTo) {
            $assets = $assets->where('lease_end_date', '<=', convert_to_db_date($leaseEndDateTo));
        }

        if ($dateDeployedFrom) {
            $assets = $assets->where('date_deployed', '>=', convert_to_db_date($dateDeployedFrom));
        }

        if ($dateDeployedTo) {
            $assets = $assets->where('date_deployed', '<=', convert_to_db_date($dateDeployedTo));
        }

        if ($loanerReturnDateFrom) {
            $assets = $assets->where('loaner_return_date', '>=', convert_to_db_date($loanerReturnDateFrom));
        }

        if ($loanerReturnDateTo) {
            $assets = $assets->where('loaner_return_date', '<=', convert_to_db_date($loanerReturnDateTo));
        }

        if ($lostDateFrom) {
            $assets = $assets->where('lost_date', '>=', convert_to_db_date($lostDateFrom));
        }

        if ($lostDateTo) {
            $assets = $assets->where('lost_date', '<=', convert_to_db_date($lostDateTo));
        }

        $assets = $assets->get();
        $assetView = view('assets.partials.assets', compact('assets'))->render();

        return response()->json($assetView);
    }


    public function prodSearch()
    {
        $assetType = request('asset_type');
        $status = request('status');

        $makeAndModel = request('make_and_model');
        $technicalSpec = request('technical_spec');
        $location = request('location');
        $user = request('user');
        $assetAge = request('asset_age_value');
        $ageUnit = request('asset_age_unit');
        $assetTag = request('asset_tag');
        $serialNo = request('serial_no');

        $building = request('building');

        $assets = Asset::with('location', 'user', 'assetType', 'makeAndModel.manufacturer', 'technicalSpec', 'assetStatus', 'parentAsset', 'latestAssetHistory');

        $assets = $assets->avAsset();

        if ($assetType) {
            $assets = $assets->whereIn('asset_type_id', $assetType);
        }

        if ($status) {
            $assets = $assets->whereIn('asset_status_id', $status);
        }

        if ($makeAndModel) {
            $assets = $assets->whereIn('make_and_model_id', $makeAndModel);
        }

        if ($technicalSpec) {
            $assets = $assets->whereIn('technical_spec_id', $technicalSpec);
        }

        if ($location) {
            $assets = $assets->whereIn('location_id', $location);
        }

        if ($building) {
            $assets = $assets->whereIn('location_id', $building);
        }

        if ($user) {
            $assets = $assets->whereIn('user_id', $user);
        }

        if ($assetAge) {
            if ($ageUnit == 'day') {
                $date = Carbon::now()->subDays($assetAge);
            }

            if ($ageUnit == 'month') {
                $date = Carbon::now()->subMonths($assetAge);
            }

            if ($ageUnit == 'year') {
                $date = Carbon::now()->subYears($assetAge);
            }

            $assets = $assets->where('created_at', '<=', $date);
        }

        if ($assetTag) {

            $assetTag = $this->getParentTags($assetTag);
            $assetTag = $this->getParentTags($assetTag); // Code for Grand Child
            $assets = $assets->whereIn('asset_tag', $assetTag);
        }

        if ($serialNo) {
            $assets = $assets->whereIn('serial_no', $serialNo);
        }

        $assets = $assets->get();
        $assetView = view('assets.partials.assets-prod', compact('assets'))->render();

        return response()->json($assetView);
    }

    public function getParentTags($assetTag)
    {
        $parentTags = Asset::whereIn('id', Asset::whereIn('asset_tag', $assetTag)->get()->pluck('parent_asset_id'))->get()->pluck('asset_tag');

        if ($parentTags) {
            foreach ($parentTags as $value) {
                array_push($assetTag, $value);
            }
        }

        return $assetTag;
    }

    public function listHardware()
    {
        $makeAndModel = HardwareStandards::getHardwareStandardsFilter(request('id'), request('type'))->get();

        $result = $makeAndModel->map(
            function ($item) {
                return [
                    'id' => $item->id,
                    'hardware' => $item->makemodelName
                ];
            }
        )->sortBy('hardware');

        $result = $result->values();

        return $result;
    }

    public function listTechnicalSpec()
    {
        $technicalSpecs = TechnicalSpecs::getTechnicalSpecsFilter(request('id'), request('type'))->orderBy('details')->get();

        return $technicalSpecs->map(
            function ($item) {
                return [
                    'id' => $item->id,
                    'details' => $item->details
                ];
            }
        );
    }


    public function listHardwareWithManufacturer()
    {
        $makeAndModel = HardwareStandards::getHardwareWithManufacturerAndAssetType(request('manufacturer_id'), request('asset_type_id'))->get();

        return $makeAndModel->map(
            function ($item) {
                return [
                    'id' => $item->id,
                    'hardware' => $item->makemodelName
                ];
            }
        );
    }

    public function listManufacturer()
    {
        $assetTypeId = request('id');

        $manufacturers = ModelsManufacturer::whereHas('makeAndModel', function ($query) use ($assetTypeId) {
            if ($assetTypeId) {
                if (is_array($assetTypeId)) {
                    $query->whereIn('asset_type_id', $assetTypeId);
                } else {
                    $query->where('asset_type_id', $assetTypeId);
                }
            }
        })->get();

        return $manufacturers->map(
            function ($item) {
                return [
                    'id' => $item->id,
                    'manufacturer' => $item->name
                ];
            }
        );
    }
}
