<?php

namespace App\Http\Controllers\Assets;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Asset;
use App\Models\Location;
use App\Services\Asset\MoveAssetService;
use App\User;
use Illuminate\Support\Facades\Auth;

class MoveController extends Controller
{

    public function __construct(protected MoveAssetService $moveAssetService) {}

    /**
     * Shows the move asset view.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        session(['count_add' => 0]);
        $data = ['title' => 'Move Asset', 'parent' => 'Asset', 'type' => 'it', 'parentUrl' => $this->getParentUrl('it')];
        return view('assets.move.move', compact('data'));
    }

    public function av()
    {
        session(['count_add' => 0]);
        $data = ['title' => 'Move AV Asset', 'parent' => 'AV Asset', 'type' => 'avassets', 'parentUrl' => $this->getParentUrl('avassets')];

        return view('assets.move.move', compact('data'));
    }

    public function mobile()
    {
        session(['count_add' => 0]);
        $data = ['title' => 'Move Mobile Asset', 'parent' => 'Mobile Asset', 'type' => 'mobile', 'parentUrl' => $this->getParentUrl('mobile')];

        return view('assets.move.move', compact('data'));
    }

    public function network()
    {
        session(['count_add' => 0]);
        $data = ['title' => 'Move Network Asset', 'parent' => 'Network Asset', 'type' => 'network', 'parentUrl' => $this->getParentUrl('network')];

        return view('assets.move.move', compact('data'));
    }

    public function research()
    {
        session(['count_add' => 0]);
        $data = ['title' => 'Move Research Asset', 'parent' => 'Research Asset', 'type' => 'research', 'parentUrl' => $this->getParentUrl('research')];

        return view('assets.move.move', compact('data'));
    }

    public function getParentUrl($type)
    {
        if ($type == 'network') {
            return "/network-assets";
        }
        if ($type == 'it') {
            return "/assets";
        }
        if ($type == 'mobile') {
            return "/mobile-assets";
        }
        if ($type == 'avassets') {
            return "/av-assets";
        }
        if ($type == 'research') {
            return "/research-assets";
        }
    }

    public function updateRows($count = 1)
    {
        if (session('count_add')) {
            $count = session('count_add') + 1;
        }
        session(['count_add' => $count]);

        $asset = Asset::with('makeAndModel.manufacturer', 'technicalSpec')->where('serial_no', request('serial_no'))->orWhere('asset_tag', request('serial_no'))->first();
        $toLocation = Location::findOrFail(request('location_id'));

        $view = view('assets.partials.added-assets-move', compact('asset', 'toLocation', 'count'))->render();
        return response()->json($view);
    }

    /** move mulitple no.of assets from move page
     * @return [type]
     */
    public function store()
    {

        $count = request('count');

        $user = User::find(Auth::id());

        $movedCount = 0;

        for ($i = 1; $i <= $count; $i++) {
            if ($this->moveAssetService->moveAsset(request()->all(), $user, $i) === true) {
                $movedCount++;
            }
        }

        $notMovedCount = $count - $movedCount;

        session(['count_add' => 0]);

        $message = '';
        $errorMessage = '';

        $category = ucfirst(request('category'));

        if ($movedCount > 0) {
            $message = "$movedCount $category asset" . ($movedCount > 1 ? 's' : '') . " moved.";
        }

        if ($notMovedCount > 0) {
            $errorMessage = "$notMovedCount $category asset" . ($notMovedCount > 1 ? 's were' : ' was') . " not moved.";
        }

        if ($movedCount === 0) {
            return redirect(route("assets-move.index"))->with('error', "No $category assets were moved.");
        }

        if ($category === "Mobile") {
            return redirect(route('assets-move.mobile'))->with('message', $message)->with('error', $errorMessage);
        }

        if ($category === "Network") {
            return redirect(route('assets-move.network'))->with('message', $message)->with('error', $errorMessage);
        }

        return redirect(route('assets-move.index'))->with('message', $message)->with('error', $errorMessage);
    }

    /** Move an asset
     * @return [type]
     */
    public function moveSingleAsset(Request $request)
    {
        $request->merge([
            'to_location_id' => request('location_id')
        ]);

        $user = User::find(Auth::id());

        if ($this->moveAssetService->moveAsset(request()->all(), $user, '') === false) {
            return back()->with('error', 'Invalid form data.');
        }

        return back()->with('message', 'The asset has been moved.');
    }
}
