<?php

namespace App\Http\Controllers\Assets;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Asset;
use App\Services\Asset\LinkAssetService;
use Illuminate\Support\Facades\Auth;
use App\User;

class LinkController extends Controller
{
    public function __construct(protected LinkAssetService $linkAssetService) {}

    public function index()
    {
        if (session('count_add')) {
            session(['count_add' => 0]);
        }

        $data = ['title' => 'Link Asset', 'parent' => 'Asset', 'type' => 'it', 'parentUrl' => '/assets'];
        return view('assets.link.link', compact('data'));
    }
    public function av()
    {

        $data = ['title' => 'Link AV Asset', 'parent' => 'AV Asset', 'type' => 'avassets', 'parentUrl' => $this->getParentUrl('avassets')];
        return view('assets.link.link', compact('data'));
    }

    public function mobile()
    {

        $data = ['title' => 'Link Mobile Asset', 'parent' => 'Mobile Asset', 'type' => 'mobile', 'parentUrl' => $this->getParentUrl('mobile')];
        return view('assets.link.link', compact('data'));
    }

    public function network()
    {
        $data = ['title' => 'Link Network Asset', 'parent' => 'Network Asset', 'type' => 'network', 'parentUrl' => $this->getParentUrl('network')];
        return view('assets.link.link', compact('data'));
    }

    public function research()
    {
        $data = ['title' => 'Link Research Asset', 'parent' => 'Research Asset', 'type' => 'research', 'parentUrl' => $this->getParentUrl('research')];
        return view('assets.link.link', compact('data'));
    }

    public function getParentUrl($type)
    {
        if ($type == 'network') {
            return "/network-assets";
        }
        if ($type == 'it') {
            return "/assets";
        }
        if ($type == 'mobile') {
            return "/mobile-assets";
        }
        if ($type == 'avassets') {
            return "/av-assets";
        }
        if ($type == 'research') {
            return "/research-assets";
        }
    }

    public function updateRows($count = 1)
    {
        if (session('count_add')) {
            $count = session('count_add') + 1;
        }
        session(['count_add' => $count]);
        $parentAsset = Asset::with('makeAndModel.manufacturer')->getBySerial(request('parent_serial_no'))->first();
        $childAsset = Asset::getBySerial(request('child_serial_no'))->first();

        $view = view('assets.partials.added-assets-link', compact('parentAsset', 'childAsset', 'count'))->render();
        return response()->json($view);
    }

    /** stores the asset links from link page
     * @return [type]
     */
    public function store()
    {
        $count = request('count');
        $user = User::find(Auth::id());

        $linkedCount = 0;

        for ($i = 1; $i <= $count; $i++) {

            if ($this->linkAssetService->linkAsset(request()->all(), $user, $i) === true) {
                $linkedCount++;
            }
        }

        $notLinkedCount = $count - $linkedCount;

        session(['count_add' => 0]);

        $message = '';
        $errorMessage = '';

        $category = ucfirst(request('category'));

        // Assuming $linkedCount and $notLinkedCount are already defined
        if ($linkedCount > 0) {
            $message = "$linkedCount $category asset" . ($linkedCount > 1 ? 's' : '') . " linked.";
        }

        if ($notLinkedCount > 0) {
            $errorMessage = "$notLinkedCount $category asset" . ($notLinkedCount > 1 ? 's were' : ' was') . " not linked.";
        }

        if ($linkedCount === 0) {
            return redirect(route("assets-link.index", ['type' => request('category')]))->with('error', "No $category assets were linked.");
        }

        switch ($category) {
            case 'Server':
                return redirect(route('assets-link.server', ['type' => request('category')]))->with('message', $message)->with('error', $errorMessage);

            case 'Network':
                return redirect(route('assets-link.network', ['type' => request('category')]))->with('message', $message)->with('error', $errorMessage);

            case 'Research':
                return redirect(route('assets-link.research', ['type' => request('category')]))->with('message', $message)->with('error', $errorMessage);

            case 'Mobile':
                return redirect(route('assets-link.mobile', ['type' => request('category')]))->with('message', $message)->with('error', $errorMessage);

            default:
                return redirect(route('assets-link.index', ['type' => request('category')]))->with('message', $message)->with('error', $errorMessage);
        }
    }

    /**
     * Linking asset from detail page
     * 
     * @return object
     */
    public function storeLinkFromDetailsPage(Request $request)
    {
        $user = User::find(Auth::id());

        if ($this->linkAssetService->linkAsset(request()->all(), $user, '') === false) {
            return back()->with('error', 'Invalid form data.');
        }

        return back()->with('message', 'The assets linked.');
    }

    /**
     * Return a partial view of linked assets for a given parent asset.
     * 
     * @param int $id The parent asset ID.
     * @param int $parent_id The ID of the parent asset of the parent asset ID.
     * 
     * @return \Illuminate\Http\JsonResponse The partial view of the linked assets.
     */
    public function getLinks()
    {
        request()->validate([
            'id' => 'required',
        ]);
        $parentAsset = null;
        $id = request('id');
        $childrenAsset = Asset::with('makeAndModel.manufacturer', 'technicalSpec')->where('parent_asset_id', $id)->get();

        if (!empty(request('parent_id'))) {
            $parentAsset = Asset::with('makeAndModel.manufacturer', 'technicalSpec')->find(request('parent_id'));
        }

        $view = view('assets.modals.partials.link-assets', compact('childrenAsset', 'parentAsset', 'id'))->render();

        return response()->json($view);
    }

    /**
     * Remove a set of links between assets.
     * 
     * @return \Illuminate\Http\RedirectResponse The redirect response with a message.
     */
    public function removeLinks()
    {
        $links = request('link_asset');

        if (empty($links)) {
            return redirect()->back()->with('error', 'No links to remove');
        }

        if ($this->linkAssetService->removeLinks($links) === true) {
            return redirect()->back()->with('message', 'The selected links has been removed.');
        }
    }
}
