<?php

namespace App\Http\Controllers\Assets;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\Settings\History\AssetDetailsHistoryService;
use Exception;

/**Controller class to manage the asset history in asset details page. */
class AssetDetailsHistoryController extends Controller
{
    /**
     * Constructor for the class.
     *
     * @param AssetDetailsHistoryService $service
     */
    public function __construct(protected AssetDetailsHistoryService $service) {}

    /**
     * Fetch asset history to show in asset detail page
     *
     * @throws Exception description of exception
     * @return ReportJsonResponse
     */
    public function data()
    {
        try {
            $filteredData = $this->service->data();
            $history =  $filteredData['history'];
            $data = [];

            if (!empty($history)) {
                $data = $this->service->getReportData($history, request('start'));
            }

            return new ReportJsonResponse(request()->input('draw'), $data, $filteredData['count']);
        } catch (Exception $e) {
            return response()->json(['message' => $e->getMessage()], 500);
        }
    }
}
