<?php

namespace App\Http\Controllers\Api\Zendesk;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Asset;
use Exception;
use Illuminate\Support\Facades\Log;

/**
 * Controller class for the search assets from Jira plugin
 */
class TeqtivityAssetsSearchController extends controller
{


	/**
	 * Search for assets by serial number or asset tag.
	 *
	 * @param \Illuminate\Http\Request $request The incoming request instance.
	 *
	 * @return \Illuminate\Support\Collection|null The collection of matched assets or null in case of an error.
	 */
	public function index(Request $request)
	{
		try {
			if (request('search')) {
				$search 		= $request->search;
				$canBeAssigned 	= getCanBeUpdatedToStatus('assigned');

				$res = Asset::select(['id', 'serial_no', 'asset_tag'])
					->where('serial_no', 'like', $search . '%')
					->orWhere('asset_tag', 'like', $search . '%')
					->whereHas(
						'assetStatus',
						function ($query) use ($canBeAssigned) {
							$query->whereIn('slug', $canBeAssigned);
						}
					)
					->limit(10)->get();

				return $res->mapWithKeys(
					function ($item, $key) {
						return [
							$key => [
								'id'        => $item->id,
								'serial_no' => $item->serial_no,
								'asset_tag' => $item->asset_tag
							],
						];
					}
				);
			}
		} catch (Exception $e) {
			Log::channel('daily')->error($e->getMessage());
		}

		return null;
	}
}
