<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Api\VendorApiService;

/**
 * Controller class for Vendor API
 */
class VendorApiController extends Controller
{
    /**
     * @var VendorApiService
     */
    protected $vendorApiService;

    /**
     * Create a new VendorApiController instance.
     *
     * @param VendorApiService $vendorApiService
     */
    public function __construct(VendorApiService $vendorApiService)
    {
        $this->vendorApiService = $vendorApiService;
    }

    /**
     * Get all vendors.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $request->validate([
            'search' => ['nullable', 'regex:/^[a-z0-9,@. _-]+$/i']
        ]);

        $vendors = $this->vendorApiService->getVendors($request);

        if ($vendors->count() == 0) {
            return $this->vendorApiService->noResultResponse('Vendor not found');
        }

        return $this->vendorApiService->successResponse($vendors);
    }
}
