<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\GetUserRequest;
use App\Services\Api\UserApiService;
use Illuminate\Http\Request;

class UserApiController extends Controller
{
    /**
     * @var UserApiService
     */
    protected $userApiService;

    /**
     * Create a new UserApiController instance.
     *
     * @param UserApiService $userApiService
     */
    public function __construct(UserApiService $userApiService)
    {
        $this->userApiService = $userApiService;
    }

    /**
     * Get all users along with filters.
     *
     * @param GetUserRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function findUsers(GetUserRequest $request)
    {

        if ($this->userApiService->checkDataLimit($request->limit)) {
            return $this->userApiService->limitExceededResponse();
        }

        $users = $this->userApiService->getUsers($request);

        if ($users->count() == 0) {
            return $this->userApiService->noResultResponse('No Users Found');
        }

        return $this->userApiService->successResponse($users);
    }


    /**
     * Search users using simple search.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchUser(Request $request)
    {
        $request->validate([
            'search' => ['required', 'regex:/^[a-z0-9,@. _-]+$/i']
        ]);

        if ($this->userApiService->checkDataLimit($request->limit)) {
            return $this->userApiService->limitExceededResponse();
        }

        $users = $this->userApiService->searchUsers($request);

        if ($users->count() == 0) {
            return $this->userApiService->noResultResponse('No Users Found');
        }

        return $this->userApiService->successResponse($users);
    }
}
