<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\Api\UserUpdateApiService;

class UpdateUserApiController extends Controller
{
    /**
     *
     * @var UserUpdateApiService
     */
    protected $userUpdateApiService;

    /**
     * Update a new controller instance.
     *
     * @param UserUpdateApiService $userUpdateApiService
     */
    public function __construct(UserUpdateApiService $userUpdateApiService)
    {
        $this->userUpdateApiService = $userUpdateApiService;
    }

    /**
     * Handle the user creation request.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
    	$errors = $this->userUpdateApiService->validateFields();

    	if($errors) {
	        return $this->userUpdateApiService->validateErrorResponse($errors);
    	}

    	$userData = $this->userUpdateApiService->getData();

        $this->userUpdateApiService->saveData($userData);

        return $this->userUpdateApiService->successResponse([], 'Updated User');
    }
}
