<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\Api\AssetUpdateApiService;

/**
 * Controller class for updating assets via API.
 */
class UpdateAssetApiController extends Controller
{
    /**
     * @var AssetUpdateApiService
     */
    protected $assetUpdateApiService;

    /**
     * Create a new UpdateAssetApiController instance.
     *
     * @param AssetUpdateApiService $assetUpdateApiService
     */
    public function __construct(AssetUpdateApiService $assetUpdateApiService)
    {
        $this->assetUpdateApiService = $assetUpdateApiService;
    }

    /**
     * Update an asset via API.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update()
    {
    	$errors = $this->assetUpdateApiService->validateFields();

    	if($errors) {
	        return $this->assetUpdateApiService->validateErrorResponse($errors);
    	}

    	$assetData = $this->assetUpdateApiService->getData();

        if (!$assetData) {
            return $this->assetUpdateApiService->errorResponse('Invalid combination of Asset type - Manufacturer - Hardware Standard - Technical Spec');
        }

        $this->assetUpdateApiService->saveData($assetData);

        return $this->assetUpdateApiService->successResponse([], 'Updated Asset');
    }
}
