<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\GetTechSpecRequest;
use App\Services\Api\TechSpecApiService;

/**
 * Controller class for Asset Type API
 */
class TechSpecApiController extends Controller
{
    /**
     * @var TechSpecApiService
     */
    protected $techSpecsApiService;

    /**
     * Create a new TechSpecApiController instance.
     *
     * @param TechSpecApiService $techSpecsApiService
     */
    public function __construct(TechSpecApiService $techSpecsApiService)
    {
        $this->techSpecsApiService = $techSpecsApiService;
    }

    /**
     * Get all techSpecs.
     *
     * @param GetTechSpecRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getTechSpecs(GetTechSpecRequest $request)
    {
        if ($this->techSpecsApiService->checkDataLimit($request->limit)) {
            return $this->techSpecsApiService->limitExceededResponse();
        }

        $techSpecs = $this->techSpecsApiService->getTechSpecs($request);

        if ($techSpecs->count() == 0) {
            return $this->techSpecsApiService->noResultResponse('TechSpecs not found');
        }

        return $this->techSpecsApiService->successResponse($techSpecs);
    }

    /**
     * Search techSpecs using simple search.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchTechSpecs(Request $request)
    {
        $request->validate([
            'search' => ['required', 'regex:/^[a-z0-9,@. _-]+$/i']
        ]);

        if ($this->techSpecsApiService->checkDataLimit($request->limit)) {
            return $this->techSpecsApiService->limitExceededResponse();
        }

        $techSpecs = $this->techSpecsApiService->searchTechSpecs($request);

        if ($techSpecs->count() == 0) {
            return $this->techSpecsApiService->noResultResponse('TechSpecs not found');
        }

        return $this->techSpecsApiService->successResponse($techSpecs);
    }
}
